% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate.mdl_df}
\alias{generate.mdl_df}
\alias{generate.mdl_ts}
\title{Generate responses from a mable}
\usage{
\method{generate}{mdl_df}(x, new_data = NULL, h = NULL, times = 1,
  seed = NULL, ...)

\method{generate}{mdl_ts}(x, new_data = NULL, h = NULL, times = 1,
  seed = NULL, ...)
}
\arguments{
\item{x}{A mable.}

\item{new_data}{The data to be generated (time index and exogenous regressors)}

\item{h}{The simulation horizon (can be used instead of \code{new_data} for regular
time series with no exogenous regressors).}

\item{times}{The number of replications.}

\item{seed}{The seed for the random generation from distributions.}

\item{...}{Additional arguments for individual simulation methods.}
}
\description{
Use a model's fitted distribution to simulate additional data with similar
behaviour to the response. This is a tidy implementation of
\code{\link[stats]{simulate}}.
}
\details{
Innovations are sampled by the model's assumed error distribution.
If \code{bootstrap} is \code{TRUE}, innovations will be sampled from the model's
residuals. If \code{new_data} contains the \code{.innov} column, those values will be
treated as innovations for the simulated paths..
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(dplyr)
UKLungDeaths <- as_tsibble(cbind(mdeaths, fdeaths), pivot_longer = FALSE)
UKLungDeaths \%>\% 
  model(lm = TSLM(mdeaths ~ fourier("year", K = 4) + fdeaths)) \%>\% 
  generate(UKLungDeaths, times = 5)
}
}
