% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{glance.ARIMA}
\alias{glance.ARIMA}
\title{Glance an ARIMA model}
\format{
A data frame with 1 row, with columns:
\describe{
\item{sigma2}{The unbiased variance of residuals. Calculated as \code{sum(residuals^2) / (num_observations - num_pararameters + 1)}}
\item{log_lik}{The log-likelihood}
\item{AIC}{Akaike information criterion}
\item{AICc}{Akaike information criterion, corrected for small sample sizes}
\item{BIC}{Bayesian information criterion}
\item{ar_roots, ma_roots}{The model's characteristic roots}
}
}
\usage{
\method{glance}{ARIMA}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the ARIMA model.
}
\examples{
USAccDeaths \%>\%
  as_tsibble() \%>\%
  model(arima = ARIMA(log(value) ~ pdq(0, 1, 1) + PDQ(0, 1, 1))) \%>\%
  glance()
}
