% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar.R
\name{AR}
\alias{AR}
\alias{report.AR}
\title{Estimate a AR model}
\usage{
AR(formula, ic = c("aicc", "aic", "bic"), ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{ic}{The information criterion used in selecting the model.}

\item{...}{Further arguments for arima}
}
\value{
A model specification.
}
\description{
Searches through the vector of lag orders to find the best AR model which
has lowest AIC, AICc or BIC value. It is implemented using OLS, and behaves
comparably to \code{\link[stats:ar.ols]{stats::ar.ols()}}.
}
\details{
Exogenous regressors and \code{\link{common_xregs}} can be specified in the model
formula.
}
\section{Specials}{


\subsection{pdq}{
The \code{order} special is used to specify the lag order for the auto-regression.
\preformatted{
order(p = 0:15, fixed = list())
}

\tabular{ll}{
\code{p}        \tab The order of the auto-regressive (AR) terms. If multiple values are provided, the one which minimises \code{ic} will be chosen.\cr
\code{fixed}    \tab A named list of fixed parameters for coefficients. The names identify the coefficient, beginning with \code{ar}, and then followed by the lag order. For example, \code{fixed = list(ar1 = 0.3, ar3 = 0)}.
}
}

\subsection{xreg}{
Exogenous regressors can be included in an AR model without explicitly using the \code{xreg()} special. Common exogenous regressor specials as specified in \code{\link{common_xregs}} can also be used. These regressors are handled using \code{\link[stats:model.frame]{stats::model.frame()}}, and so interactions and other functionality behaves similarly to \code{\link[stats:lm]{stats::lm()}}.

The inclusion of a constant in the model follows the similar rules to \code{\link[stats:lm]{stats::lm()}}, where including \code{1} will add a constant and \code{0} or \code{-1} will remove the constant. If left out, the inclusion of a constant will be determined by minimising \code{ic}.

\preformatted{
xreg(..., fixed = list())
}

\tabular{ll}{
\code{...}      \tab Bare expressions for the exogenous regressors (such as \code{log(x)})\cr
\code{fixed}    \tab A named list of fixed parameters for coefficients. The names identify the coefficient, and should match the name of the regressor. For example, \code{fixed = list(constant = 20)}.
}
}
}

\examples{
luteinizing_hormones <- as_tsibble(lh)
fit <- luteinizing_hormones \%>\%
  model(AR(value ~ order(3)))

report(fit)

fit \%>\%
  forecast() \%>\%
  autoplot(luteinizing_hormones)
}
\seealso{
\href{https://otexts.com/fpp3/AR.html}{Forecasting: Principles and Practices, Vector autoregressions (section 11.2)}
}
