% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{generate.RW}
\alias{generate.RW}
\title{Generate new data from a fable model}
\usage{
\method{generate}{RW}(x, new_data, bootstrap = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampled errors.}

\item{...}{Additional arguments for forecast model methods.}
}
\description{
Simulates future paths from a dataset using a fitted model. Innovations are
sampled by the model's assumed error distribution. If \code{bootstrap} is \code{TRUE},
innovations will be sampled from the model's residuals. If \code{new_data}
contains the \code{.innov} column, those values will be treated as innovations.
}
\examples{
as_tsibble(Nile) \%>\%
  model(NAIVE(value)) \%>\%
  generate()

library(tsibbledata)
aus_production \%>\%
  model(snaive = SNAIVE(Beer ~ lag("year"))) \%>\%
  generate()
}
\seealso{
\code{\link[fabletools:generate.mdl_df]{fabletools::generate.mdl_df}}
}
