% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_volume.R
\name{erode_vol}
\alias{erode_vol}
\title{Erode volumetric mask}
\usage{
erode_vol(vol, n_erosion = 1, out_of_mask_val = NA)
}
\arguments{
\item{vol}{The volume to erode. Out-of-mask voxels should be indicated by a
value in \code{out_of_mask_val}.}

\item{n_erosion}{The number of layers to erode the mask by.}

\item{out_of_mask_val}{A voxel is not included in the mask if and only if its
value is in this vector. The first value in this vector will be used to replace
the eroded voxels. Default: \code{NA}.}
}
\value{
The eroded \code{vol}. It is the same as \code{vol} but with eroded
voxels replaced with the value \code{out_of_mask_val[1]}.
}
\description{
Erode a volumetric mask by a certain number of voxel layers. For each layer,
any in-mask voxel adjacent to at least one out-of-mask voxel is removed
from the mask.
}
\details{
Diagonal voxels are not considered adjacent, i.e. the voxel at (0,0,0) is not
adjacent to the voxel at (1,1,0) or (1,1,1), although it is adjacent to
(1,0,0).
}
