% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_controls.R
\name{set_controls}
\alias{set_controls}
\title{Set and check controls}
\usage{
set_controls(controls = NULL)
}
\arguments{
\item{controls}{A list of controls.
Either none, all, or selected parameters can be specified.
Unspecified parameters are set to default values (the values in brackets).
If \code{hierarchy = TRUE}, parameters with a \code{(*)} must be a vector of
length 2, where the first entry corresponds to the coarse-scale and the
second entry to the fine-scale layer.
\itemize{
\item \code{hierarchy} (\code{FALSE}):
A boolean, set to \code{TRUE} for an hierarchical HMM.
\item \code{states} \code{(*)} (\code{2}):
The number of states of the underlying Markov chain.
\item \code{sdds} \code{(*)} (\code{"t(df = Inf)"}):
Specifying the state-dependent distribution, one of the \code{"t"} (the
t-distribution) or \code{"gamma"} (the gamma distribution).
To fix one or more parameter values, write e.g.
\code{"t(df = Inf)"} or \code{"gamma(mu = 0, sigma = 1)"}, respectively.
To fix different values of one parameter for different states, separate by
"|", e.g. \code{"t(mu = -1|1)"}.
\item \code{horizon} \code{(*)} (\code{100}):
A numeric, specifying the length of the time horizon. The first entry
of \code{horizon} is ignored if \code{data} is specified.
\item \code{period} (\code{"m"}):
Only relevant if \code{hierarchy = TRUE} and \code{horizon[2] = NA}.
In this case, it specifies a flexible, periodic fine-scale time horizon
and can be one of
\itemize{
\item \code{"w"} for a week,
\item \code{"m"} for a month,
\item \code{"q"} for a quarter,
\item \code{"y"} for a year.
}
\item \code{data} (\code{NA}): A list of controls specifying the data. If
\code{data = NA}, data gets simulated. Otherwise:
\itemize{
\item \code{file} \code{(*)}:
A character, the path to a .csv-file with financial data, which must
have a column named \code{date_column} (with dates) and
\code{data_column} (with financial data).
\item \code{date_column} \code{(*)} (\code{"Date"}):
A character, the name of the column in \code{file} with dates. Can be
\code{NA} in which case consecutive integers are used as time points.
\item \code{data_column} \code{(*)} (\code{"Close"}):
A character, the name of the column in \code{file} with financial data.
\item \code{from} (\code{NA}):
A character of the format \code{"YYYY-MM-DD"}, setting a lower data
limit. No lower limit if \code{from = NA}. Ignored if
\code{controls$data$date_column} is \code{NA}.
\item \code{to} (\code{NA}):
A character of the format \code{"YYYY-MM-DD"}, setting an upper data
limit. No upper limit if \code{from = NA}. Ignored if
\code{controls$data$date_column} is \code{NA}.
\item \code{logreturns} \code{(*)} (\code{FALSE}):
A boolean, if \code{TRUE} the data is transformed to log-returns.
\item \code{merge} (\code{function(x) mean(x)}):
Only relevant if \code{hierarchy = TRUE}. In this case, a function,
which merges a numeric vector of fine-scale data \code{x} into one
coarse-scale observation. For example,
\itemize{
\item \code{merge = function(x) mean(x)} defines the mean of the
fine-scale data as the coarse-scale observation,
\item \code{merge = function(x) mean(abs(x))} for the mean of the
absolute values,
\item \code{merge = function(x) (abs(x))} for the sum of of the
absolute values,
\item \code{merge = function(x) (tail(x,1)-head(x,1))/head(x,1)} for
the relative change of the first to the last fine-scale observation.
}
}
\item \code{fit}: A list of controls specifying the model fitting:
\itemize{
\item \code{runs} (\code{100}):
An integer, setting the number of optimization runs.
\item \code{origin} (\code{FALSE}):
A boolean, if \code{TRUE} the optimization is initialized at the true
parameter values. Only for simulated data. If \code{origin = TRUE}, this
sets \code{run = 1} and \code{accept = 1:5}.
\item \code{accept} (\code{1:3}):
An integer (vector), specifying which optimization runs are accepted
based on the output code of \code{\link[stats]{nlm}}.
\item \code{gradtol} (\code{1e-6}):
A positive numeric value, passed on to \code{\link[stats]{nlm}}.
\item \code{iterlim} (\code{200}):
A positive integer, passed on to \code{\link[stats]{nlm}}.
\item \code{print.level} (\code{0}):
One of \code{0}, \code{1}, and \code{2}, passed on to
\code{\link[stats]{nlm}}.
\item \code{steptol} (\code{1e-6}):
A positive numeric value, passed on to \code{\link[stats]{nlm}}.
}
}}
}
\value{
An object of class \code{fHMM_controls}.
}
\description{
This function sets and checks the specification of controls for the {fHMM}
package.
}
\details{
See the vignettes for more information on how to specify \code{controls}.
}
\examples{
### HMM controls
controls <- list(
  states  = 2,
  sdds    = "t(mu = 0, sigma = 1, df = 1)",
  horizon = 400,
  fit     = list("runs" = 50)
)
set_controls(controls)

### HHMM controls
controls <- list(
  hierarchy = TRUE
)
set_controls(controls)

}
