% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_levels.R
\name{reorder_levels}
\alias{reorder_levels}
\title{Order levels of factor columns using fct_reorder}
\usage{
reorder_levels(data, cols = c("group", "facet_x", "facet_y"), y = "y",
  .desc = rep(TRUE, length(cols)))
}
\arguments{
\item{data}{A data.frame.}

\item{cols}{Names of columns to reorder.}

\item{y}{Numeric column for order priority.}

\item{.desc}{A logical vector of length 1 or ncol(data). Default is TRUE for
all columns in \code{cols}.}
}
\value{
A data.frame.
}
\description{
Order levels of factor columns using fct_reorder
}
\examples{
str(ezplot:::reorder_levels(mtcars, "cyl", "1"))
str(ezplot:::reorder_levels(mtcars, "cyl", "1", FALSE))
str(ezplot:::reorder_levels(mtcars, "cyl", "mpg"))
}
