% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_spline_data.R
\name{make_boot_splines_data}
\alias{make_boot_splines_data}
\alias{make_boot_splines_data.time_sequence_data}
\title{Bootstrap resample splines for time-series data.}
\usage{
make_boot_splines_data(data, predictor_column, within_subj, aoi, bs_samples,
  smoother, resolution, alpha, ...)

\method{make_boot_splines_data}{time_sequence_data}(data, predictor_column,
  within_subj, aoi = NULL, bs_samples = 1000, smoother = "smooth.spline",
  resolution = NULL, alpha = 0.05, ...)
}
\arguments{
\item{data}{The output of \code{time_sequence_data()}}

\item{predictor_column}{What predictor var to split by? Maximum two conditions}

\item{within_subj}{Are the two conditions within or between subjects?}

\item{aoi}{Which AOI do you wish to perform the analysis on?}

\item{bs_samples}{How many iterations to run bootstrap resampling? Default 1000}

\item{smoother}{Smooth data using "smooth.spline," "loess," or "none" for no smoothing}

\item{resolution}{What resolution should we return predicted splines at, in ms? e.g., 10ms = 100
intervals per second, or hundredths of a second. Default is the same size as time-bins.}

\item{alpha}{p-value when the groups are sufficiently "diverged"}

\item{...}{Ignored}
}
\value{
A bootstrapped distribution of samples for each time-bin
}
\description{
Deprecated. Performing this analysis should be done by calling \code{analyze_time_bins(test="boot_splines")}.
}
\details{
This method builds confidence intervals around proportion-looking data by bootstrap resampling.
Data can be smoothed by fitting smoothing splines. This function performs the bootstrap resampling,
\code{analyze_boot_splines} generates confidence intervals and tests for divergences.

Limited to statistical test between two conditions.
}
\section{Methods (by class)}{
\itemize{
\item \code{time_sequence_data}: 
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE )
response_window <- subset_by_window(data, window_start_time = 15500, 
                                    window_end_time = 21000, rezero = FALSE)
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate", 
                                         predictor_columns = "Sex", 
                                         summarize_by = "ParticipantName")
                                         
df_bootstrapped <- make_boot_splines_data(response_time, 
                                          predictor_column = 'Sex', 
                                          within_subj = FALSE, 
                                          bs_samples = 500, 
                                          alpha = .05,
                                          smoother = "smooth.spline") 


}

