% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_blocks.R
\name{bkdiag}
\alias{bkdiag}
\title{Diagonalize blocks of a block matrix}
\usage{
bkdiag(df)
}
\arguments{
\item{df}{A block matrix with named rows and columns.}
}
\value{
Matrix \code{df} with blocks of dimension \code{NxN} diagonalized.
}
\description{
Diagonalize each block of a block matrix, so sectors of origin become also
sectors of destination. Blocks of dimension \code{NxN} will remain
\code{NxN}, but diagonalized, and blocks of dimensions \code{Nx1} will
be expanded to \code{NxN} and then diagonalized.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
# Normal version of matrix Y
wio$Y
# Diagonal version (show first columns only)
bkdiag(wio$Y)[, 1:6]
}
