% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sec_codes.R
\name{get_sec_codes}
\alias{get_sec_codes}
\title{Get the ISO3 codes of standard sector groups}
\usage{
get_sec_codes(sector_id, wiotype = "icio2021", remove_letter = FALSE)
}
\arguments{
\item{sector_id}{String, sector or sector group code. Available
\code{sector_ids} can be obtained with the command
\code{\link[=info_sec]{info_sec()}}.}

\item{wiotype}{String, type of input-output database.}

\item{remove_letter}{Boolean. If \code{TRUE}, the initial letter from
the sector code will be removed: \code{D20} or \code{C20} will
become \verb{_20}. This is needed to grep rows and columns, as
country-sector naming follows the pattern \code{AUS_01T02}, i.e.,
without the initial letter \code{D} or \code{C}.}
}
\value{
Codes of sector ready to grep, e.g. \verb{_01|_02|_03}.
}
\description{
Gets the ISO3 codes of standard sector groups available for the
different input-output tables. The resulting format can be used to
extract elements of a matrix using \code{grep}.
}
\examples{
# Get sector codes for manufactures in the icio2021 database.
get_sec_codes("MANUF", "icio2021")
# Get sector codes for services (including construction)
get_sec_codes("SRVWC", "icio2021")
# Get sector codes for manufacturing, removing the first letter so
# the result can be used with `grep` to select specific sectors from
# a matrix
get_sec_codes("MANUF", "icio2021", remove_letter = TRUE)
}
