% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{sens_lnorm}
\alias{sens_lnorm}
\title{Adjust Log-Normal Distribution Parameters for Sensitivity Analysis}
\usage{
sens_lnorm(meanlog, sdlog, sd_mult = 2)
}
\arguments{
\item{meanlog}{A numeric vector of the means on the log scale.}

\item{sdlog}{A non-negative numeric vector of the standard deviations on the
log scale.}

\item{sd_mult}{A non-negative multiplier on the standard deviation of the
distribution.}
}
\value{
A named list of the adjusted distribution's parameters.
}
\description{
Expands (\code{sd_mult > 1}) or reduces (\code{sd_mult < 1}) the standard deviation
of the Log-Normal distribution. With high values of \code{sdlog} (i.e., \verb{> 9}),
and \code{sd_mult > 1}, the mean of the adjusted distribution can be expected to
have a mean value that is very different from the original mean, however,
the proportional difference in these values should not be very different.
}
\examples{
sens_lnorm(0, 1, 2)
sens_lnorm(0, 1, 0.8)
}
\seealso{
Other sens_dist: 
\code{\link{sens_beta}()},
\code{\link{sens_exp}()},
\code{\link{sens_gamma}()},
\code{\link{sens_gamma_pois}()},
\code{\link{sens_gamma_pois_zi}()},
\code{\link{sens_neg_binom}()},
\code{\link{sens_norm}()},
\code{\link{sens_pois}()},
\code{\link{sens_skewnorm}()},
\code{\link{sens_student}()}
}
\concept{sens_dist}
