% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_all.R
\name{logical all}
\alias{logical all}
\alias{\%agele\%}
\alias{\%agel\%}
\alias{\%agle\%}
\alias{\%agl\%}
\alias{\%age\%}
\alias{\%ag\%}
\alias{\%ale\%}
\alias{\%al\%}
\alias{\%ain\%}
\alias{\%a!in\%}
\alias{\%anin\%}
\alias{\%a==\%}
\alias{\%a!=\%}
\alias{\%ac\%}
\alias{\%ae\%}
\title{Several ways to evaluate whether all values meet logical conditions including logical range comparison helpers}
\usage{
e1 \%agele\% e2

e1 \%agel\% e2

e1 \%agle\% e2

e1 \%agl\% e2

e1 \%age\% e2

e1 \%ag\% e2

e1 \%ale\% e2

e1 \%al\% e2

e1 \%ain\% e2

e1 \%a!in\% e2

e1 \%anin\% e2

e1 \%a==\% e2

e1 \%a!=\% e2

e1 \%ac\% e2

e1 \%ae\% e2
}
\arguments{
\item{e1}{A number of vector to be evaluated}

\item{e2}{A vector of one or two numbers used to denote the
limits for logical comparison.}
}
\value{
A logical value whether all \code{e1} meet the logical conditions.
}
\description{
Several ways to evaluate whether all values meet logical conditions including logical range comparison helpers
}
\examples{

1:5 \%agele\% c(2, 4)
1:5 \%agele\% c(4, 2) # order does not matter uses min / max

1:5 \%agel\% c(2, 4)
1:5 \%agel\% c(4, 2) # order does not matter uses min / max

1:5 \%agle\% c(2, 4)
1:5 \%agle\% c(4, 2) # order does not matter uses min / max

1:5 \%agl\% c(2, 4)
1:5 \%agl\% c(4, 2) # order does not matter uses min / max

1:5 \%age\% 2
1:5 \%age\% 4

1:5 \%ag\% 2
1:5 \%ag\% 4

1:5 \%ale\% 2
1:5 \%ale\% 4

1:5 \%al\% 2
1:5 \%al\% 4

1:5 \%ain\% c(2, 99)
c("jack", "jill", "john", "jane") \%ain\% c("jill", "jane", "bill")

1:5 \%a!in\% c(2, 99)
c("jack", "jill", "john", "jane") \%a!in\% c("jill", "jane", "bill")

1:5 \%a==\% 1:5
1:5 \%a==\% 5:1

1:5 \%a!=\% 1:5
1:5 \%a!=\% 5:1
1:5 \%a!=\% c(5, 4, 1, 3, 2)
## define a variable
sample_data <- c(1, 3, 9, 5, NA, -9)

## suppose that we expect that values should fall in [1, 10]
## unless they are special character, -9 used for unknown / refused
sample_data \%ac\% "( >= 1 & <= 10 ) | == -9"

## we might expect some missing values and be OK as long as
## above conditions are met or values are missing
sample_data \%ac\% "( >= 1 & <= 10 ) | == -9 | is.na"

## equally we might be expecting NO missing values
## and want missing values to come up as FALSE
sample_data \%ac\% "(( >= 1 & <= 10 ) | == -9) & !is.na"

## clean up
rm(sample_data)
## define a variable
sample_data <- c(1, 3, 9, 5, -9)

sample_data \%ae\% "(-8, 1] | [2, 9)"
sample_data \%ae\% "(-Inf, Inf)"

## clean up
rm(sample_data)
}
