% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_pubchem.R
\name{extr_chem_info}
\alias{extr_chem_info}
\title{Query Chemical Information from IUPAC Names}
\usage{
extr_chem_info(iupac_names, verbose = TRUE)
}
\arguments{
\item{iupac_names}{A character vector of IUPAC names. These are standardized names
of chemical compounds that will be used to search in the PubChem database.}

\item{verbose}{A logical value indicating whether to print detailed messages.
Default is TRUE.}
}
\value{
A data frame with phisio-chemical information on the queried compounds,
including but not limited to:
\describe{
\item{iupac_name}{The IUPAC name of the compound.}
\item{cid}{The PubChem Compound Identifier (CID).}
\item{isomeric_smiles}{The SMILES string (Simplified Molecular Input Line
Entry System).}
}
}
\description{
This function takes a vector of IUPAC names and queries the PubChem database
(using the \code{webchem} package) to obtain the corresponding CASRN and CID for
each compound. It reshapes the resulting data, ensuring that each compound has
a unique row with the CID, CASRN, and additional chemical properties.
}
\examples{
\donttest{
# Example with formaldehyde and aflatoxin
extr_chem_info(iupac_names = c("Formaldehyde", "Aflatoxin B1"))
}
}
