% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-distribution.R
\name{PowerDist}
\alias{PowerDist}
\alias{dpower}
\alias{ppower}
\alias{qpower}
\alias{rpower}
\title{Power distribution}
\usage{
dpower(x, alpha, beta, log = FALSE)

ppower(q, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qpower(p, alpha, beta, lower.tail = TRUE, log.p = FALSE)

rpower(n, alpha, beta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta}{parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the power distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{\beta x^{\beta-1}}{\alpha^\beta}
}{
f(x) = (\beta*x^(\beta-1)) / (\alpha^\beta)
}

Cumulative distribution function
\deqn{
F(x) = \frac{x^\beta}{\alpha^\beta}
}{
F(x) = x^\beta / \alpha^\beta
}

Quantile function
\deqn{
F^{-1}(p) = \alpha p^{1/\beta}
}{
F^-1(p) = \alpha * p^(1/\beta)
}
}
\examples{

x <- rpower(1e5, 5, 16)
hist(x, 100, freq = FALSE)
curve(dpower(x, 5, 16), 2, 6, col = "red", add = TRUE, n = 5000)
hist(ppower(x, 5, 16))
plot(ecdf(x))
curve(ppower(x, 5, 16), 2, 6, col = "red", lwd = 2, add = TRUE)

}
\concept{
Univariate

Continuous
}
\keyword{distribution}
