% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet-multinomial-distribution.R
\name{DirMnom}
\alias{DirMnom}
\alias{ddirmnom}
\alias{rdirmnom}
\title{Dirichlet-multinomial (multivariate Polya) distribution}
\usage{
ddirmnom(x, size, alpha, log = FALSE)

rdirmnom(n, size, alpha)
}
\arguments{
\item{x}{\eqn{k}-column matrix of quantiles.}

\item{size}{numeric vector; number of trials (zero or more).}

\item{alpha}{\eqn{k}-values vector or \eqn{k}-column matrix;
concentration parameter. Must be positive.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density function, cumulative distribution function and random generation
for the Dirichlet-multinomial (multivariate Polya) distribution.
}
\details{
If \eqn{(p_1,\dots,p_k) \sim \mathrm{Dirichlet}(\alpha_1,\dots,\alpha_k)}{(p[1],\dots,p[k]) ~ Dirichlet(\alpha[1],\dots,\alpha[k])} and
\eqn{(x_1,\dots,x_k) \sim \mathrm{Multinomial}(n, p_1,\dots,p_k)}{(x[1],\dots,x[k]) ~ Multinomial(n, p[1],\dots,p[k])}, then 
\eqn{(x_1,\dots,x_k) \sim \mathrm{DirichletMultinomial(n, \alpha_1,\dots,\alpha_k)}}{(x[1],\dots,x[k]) ~ DirichletMultinomial(n, \alpha[1],\dots,\alpha[k])}.

Probability density function
\deqn{
f(x) = \frac{\left(n!\right)\Gamma\left(\sum \alpha_k\right)}{\Gamma\left(n+\sum \alpha_k\right)}\prod_{k=1}^K\frac{\Gamma(x_{k}+\alpha_{k})}{\left(x_{k}!\right)\Gamma(\alpha_{k})}
}{
f(x) = (n! * \Gamma(sum(\alpha[k]))) / (\Gamma(n + sum(\alpha[k]))) * prod((\Gamma(x[k] + \alpha[k])) / (x[k]! * \Gamma(\alpha[k]))
}
}
\references{
Gentle, J.E. (2006). Random number generation and Monte Carlo methods. Springer.

Kvam, P. and Day, D. (2001) The multivariate Polya distribution in combat modeling.
Naval Research Logistics, 48, 1-17.
}
\seealso{
\code{\link{Dirichlet}}, \code{\link{Multinomial}}
}
\keyword{distribution}

