% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grp_routine.R
\name{ind_to_char}
\alias{ind_to_char}
\alias{ind_to_char_}
\title{Convert indicator data.frame to character/factor.}
\usage{
ind_to_char(data, col, ..., ret_factor = FALSE, remove = TRUE,
  mutually_exclusive = TRUE, collectively_exhaustive = TRUE)

ind_to_char_(data, col, from, ret_factor = FALSE, remove = TRUE,
  mutually_exclusive = TRUE, collectively_exhaustive = TRUE)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} or \code{\link[dplyr]{tbl}}.}

\item{col}{Name of the generated column. Use a bare name when using NSE
functions and a character (quoted) name when using SE functions (functions
that end with underscores).}

\item{...}{Specification of indicator columns. Use bare variable names.
Select all variables between \code{x} and \code{z} with \code{x:z}. For more
options, see the \code{\link[dplyr]{select}} documentation.}

\item{ret_factor}{Whether to convert the column into factor.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{mutually_exclusive}{Check if the indicators are mutually exclusive.}

\item{collectively_exhaustive}{Check if the indicators are collectively
exhaustive.}

\item{from}{Names of existing columns as character vector}
}
\description{
This is the reverse operation of using \code{\link[stats]{model.matrix}} a
factor. \code{ind_to_char} works like \code{dplyr::unite}, it combines
multiple indicator columns into one character/factor column and add it to
the data.
}
\section{Functions}{
\itemize{
\item \code{ind_to_char_}: SE version of \code{ind_to_char}.
}}

\examples{
# ind_to_char as complement to use model.matrix on a factor
df <- data.frame(x = 1:6, y = factor(c(letters[1:5], NA)))
ind_df <- as.data.frame(model.matrix(~ x + y - 1,
                                      model.frame(df, na.action = na.pass)))
ind_df  # an indicator matrix with NAs

# New character column is generated with non-selected columns kept as is.
ind_to_char(ind_df, new_y, ya:ye)
ind_to_char(ind_df, new_y, -x)
ind_to_char(ind_df, col = new_y, ya:ye, remove = FALSE)
# Returns a factor column
ind_to_char(ind_df, col = new_y, ya:ye, ret_factor = TRUE)

# Using SE
ind_to_char_(ind_df, col = "new_y", from = c("ya", "yb", "yc", "yd", "ye"))
}
