% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomy.R
\name{as.dichotomy}
\alias{as.dichotomy}
\alias{dummy}
\alias{dummy1}
\alias{is.dichotomy}
\title{Convert variable (possibly multiple choice question) to data.frame/matrix of dummy variables.}
\usage{
as.dichotomy(x, prefix = "v", keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL, presence = 1, absence = 0)

dummy(x, keep_unused = FALSE, use_na = TRUE, keep_values = NULL,
  keep_labels = NULL, drop_values = NULL, drop_labels = NULL,
  presence = 1, absence = 0)

dummy1(x, keep_unused = FALSE, use_na = TRUE, keep_values = NULL,
  keep_labels = NULL, drop_values = NULL, drop_labels = NULL,
  presence = 1, absence = 0)

is.dichotomy(x)
}
\arguments{
\item{x}{vector/factor/matrix/data.frame.}

\item{prefix}{character. By default "v".}

\item{keep_unused}{Logical. Should we create columns for unused value
labels/factor levels? FALSE by default.}

\item{use_na}{Logical. Should we use NA for rows with all NA or use 0's
instead. TRUE by default.}

\item{keep_values}{Numeric/character. Values that should be kept. By default
all values will be kept.}

\item{keep_labels}{Numeric/character. Labels/levels that should be kept. By
default all labels/levels will be kept.}

\item{drop_values}{Numeric/character. Values that should be dropped. By default
all values will be kept. Ignored if keep_values/keep_labels are provided.}

\item{drop_labels}{Numeric/character. Labels/levels that should be dropped. By
default all labels/levels will be kept. Ignored if keep_values/keep_labels are provided.}

\item{presence}{numeric value which will code presence of the level. By
default it is 1. Note that all tables functions need that \code{presence}
and \code{absence} will be 1 and 0.}

\item{absence}{numeric value which will code absence of the level. By default
it is 0. Note that all tables functions need that \code{presence} and
\code{absence} will be 1 and 0.}
}
\value{
\code{as.dichotomy} returns data.frame of class \code{dichotomy} 
  with 0,1. Columns of this data.frame have variable labels according to
  value labels of original data. If label doesn't exist for particular value
  then this value will be used as variable label. \code{dummy} returns matrix
  of class \code{dichotomy}. Column names of this matrix are value labels of
  original data.
}
\description{
This function converts variable/multiple response
variable (vector/matrix/data.frame) with category encoding into
data.frame/matrix with dichotomy encoding (0/1) suited for most statistical
analysis, e. g. clustering, factor analysis, linear regression and so on.
\itemize{ 
\item{\code{as.dichotomy}}{ returns data.frame of class 'dichotomy' with 0, 1
and possibly NA.}
\item{\code{dummy}}{ returns matrix of class 'dichotomy' with 0, 1 and possibly NA.}
\item{\code{dummy1}}{ drops last column in dichotomy matrix. It is useful in many cases
because any column of such matrix usually is linear combinations of other columns.}
}
}
\examples{
# toy example
# brands - multiple response question
# Which brands do you use during last three months? 
set.seed(123)
brands = as.dtfrm(t(replicate(20,sample(c(1:5,NA),4,replace = FALSE))))
# score - evaluation of tested product
score = sample(-1:1,20,replace = TRUE)
var_lab(brands) = "Used brands"
val_lab(brands) = autonum("
                              Brand A
                              Brand B
                              Brand C
                              Brand D
                              Brand E
                              ")

var_lab(score) = "Evaluation of tested brand"
val_lab(score) = make_labels("
                             -1 Dislike it
                              0 So-so
                              1 Like it    
                             ")

cro_cpct(as.dichotomy(brands), score)
# the same as
cro_cpct(mrset(brands), score)

# customer segmentation by used brands
kmeans(dummy(brands), 3)

# model of influence of used brands on evaluation of tested product 
summary(lm(score ~ dummy(brands)))

# prefixed data.frame 
as.dichotomy(brands, prefix = "brand_")

}
\seealso{
\code{\link{as.category}} for reverse conversion, \link{mrset},
  \link{mdset} for usage multiple-response variables with tables.
}
