% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-mod.R
\name{modScale}
\alias{modScale}
\title{Scale Data by Factor Range}
\usage{
modScale(object, alpha = 0, uniform = TRUE)
}
\arguments{
\item{object}{An \code{ExprsArray} object. The object that should undergo a
replication of some feature selection and dimension reduction history.}

\item{alpha}{An integer. The maximum range of scale factors used
for scaling if \code{uniform = TRUE}. The standard deviation
of the scale factors if \code{uniform = FALSE}. See Details.}

\item{uniform}{A boolean. Toggles whether to draw scale factors
from a uniform distribution or a normal distribution.}
}
\value{
A pre-processed \code{ExprsArray} object.
}
\description{
\code{modScale} scales a data set by making all sample vectors
 have the same total sum, then multiplying each sample vector by
 a scale factor.
}
\details{
If \code{uniform = TRUE}, scale factors are randomly sampled from
 the uniform distribution \code{(0, alpha) + 1}. Otherwise, scale
 factors are randomly sampled from the normal distribution with
 a mean of 0 and standard deviation of \code{alpha}. When using
 the normal distribution, these scale factors are transformed by
 taking the absolute value then adding one. For this reason,
 data are always unscaled when \code{alpha = 0}.
}
