% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.2-build.R
\name{doMulti}
\alias{doMulti}
\title{Perform Multiple "1 vs. all" Tasks}
\usage{
doMulti(object, top = 0, method, ...)
}
\arguments{
\item{object}{An \code{ExprsArray} object. The training set.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{method}{A character string. The method to apply.}

\item{...}{Arguments passed to the detailed function.}
}
\value{
A list of the results from \code{method}.
}
\description{
A function to execute multiple "1 vs. all" binary tasks.
}
\details{
\code{doMulti} runs once for each factor level in the
 "defineCase" column. If a training set is missing any
 one of the factor levels (e.g., owing to random cuts during
 cross-validation), the \code{ExprsModule} component that
 would refer to that class label gets replaced with an NA
 placeholder. Note that this NA placeholder will prevent a
 classifier from possibly predicting the NA class (i.e., a
 classifier can only make predictions about class
 labels that it "knows"). However, these "unknown" classes
 still impact metrics of classifier performance.
 Otherwise, see \code{\link{exprso-predict}}.
}
