% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryser.R
\name{ryser}
\alias{ryser}
\title{The Ryser method for computing an expected permutation matrix}
\usage{
ryser(A, return.permanent = FALSE)
}
\arguments{
\item{A}{A matrix of assignment likelihoods.}

\item{return.permanent}{A logical value indicating whether the function should also return the permanent of \code{A}, which is then added to the output as an attribute.}
}
\value{
\code{E(P)}, the expected permutation matrix corresponding to \code{A}.
}
\description{
Computes the expected permutation matrix and marginal likelihood from a matrix of assignment likelihoods using the Ryser method.
}
\examples{
data(A)
ryser(A)
}
