% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimum.R
\name{optimum}
\alias{optimum}
\alias{optimum_batches}
\alias{optimum_subset}
\alias{sizes_batches}
\title{Optimum values for batches}
\usage{
optimum_batches(size_data, size_subset)

optimum_subset(size_data, batches)

sizes_batches(size_data, size_subset, batches)
}
\arguments{
\item{size_data}{A numeric value of the number of samples to use}

\item{size_subset}{Numeric value of the number of sample per batch}

\item{batches}{A numeric value of the number of batches}
}
\value{
\describe{
\item{\code{optimum_batches}}{A numeric value with the number of batches to
use.}
\item{\code{optimum_subset}}{A numeric value with the maximum number of samples per batch of the data.}
\item{\code{sizes_batches}}{A numeric vector with the number of samples in each batch.}
}
}
\description{
Calculates the optimum values for number of batches or size of the batches.
If you need to do several batches it can be better to distribute it evenly
and add replicates.
}
\examples{
size_data <- 50
size_batch <- 24
(batches <- optimum_batches(size_data, size_batch))
# So now the best number of samples for each batch is less than the available
(size <- optimum_subset(size_data, batches))
# The distribution of samples per batch
sizes_batches(size_data, size, batches)
}
