% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{exclude_progress}
\alias{exclude_progress}
\title{Exclude survey progress}
\usage{
exclude_progress(
  x,
  min_progress = 100,
  id_col = "ResponseId",
  finished_col = "Finished",
  progress_col = "Progress",
  rename = TRUE,
  quiet = TRUE,
  print = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{min_progress}{Amount of progress considered acceptable to include.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{finished_col}{Column name for whether survey was completed.}

\item{progress_col}{Column name for percentage of survey completed.}

\item{rename}{Logical indicating whether to rename columns (using \code{\link[=rename_columns]{rename_columns()}})}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}

\item{silent}{Logical indicating whether to print message to console. Note
this argument controls the exclude message not the check message.}
}
\value{
An object of the same type as \code{x} that excludes rows
that have incomplete progress.
For a function that checks for these rows, use \code{\link[=check_progress]{check_progress()}}.
For a function that marks these rows, use \code{\link[=mark_progress]{mark_progress()}}.
}
\description{
The \code{exclude_progress()} function removes
rows that have incomplete progress.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The default requires 100\% completion, but lower levels of completion
maybe acceptable and can be allowed by specifying the \code{min_progress}
argument.
The finished column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that have incomplete progress.
}
\examples{
# Exclude rows with incomplete progress
data(qualtrics_text)
df <- exclude_progress(qualtrics_text)

# Remove preview data first
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_progress()

# Include a lower acceptable completion percentage
df <- qualtrics_numeric \%>\%
  exclude_preview() \%>\%
  exclude_progress(min_progress = 98)

# Do not print rows to console
df <- qualtrics_text \%>\%
  exclude_preview() \%>\%
  exclude_progress(print = FALSE)
}
\seealso{
Other progress functions: 
\code{\link{check_progress}()},
\code{\link{mark_progress}()}

Other exclude functions: 
\code{\link{exclude_duplicates}()},
\code{\link{exclude_duration}()},
\code{\link{exclude_ip}()},
\code{\link{exclude_location}()},
\code{\link{exclude_preview}()},
\code{\link{exclude_resolution}()}
}
\concept{exclude functions}
\concept{progress functions}
