% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{equal}
\alias{equal}
\alias{approx_equal}
\title{Conditional Value Matching}
\usage{
equal(x, y, tol = 1e-06, outer = FALSE)

approx_equal(x, y, tol = 1e-06, outer = FALSE)
}
\arguments{
\item{x}{numeric}

\item{y}{numeric}

\item{tol}{numeric: tolerance (default: \code{1e-6})}

\item{outer}{logical: compares directly or verifies whether \code{x} is present within \code{y} (default: FALSE).}
}
\value{
logical
}
\description{
It performs a comparison by checking if either \code{abs(x - y) < tol} when \code{outer == FALSE},
or if an \code{a} exists or a  \code{y[j]} for each \code{x[i]} such that the condition \code{abs(x[i] - y[j]) < tol} is satisfied.
}
\examples{
equal(9*1/9, 1)
}
