% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exemplar.R
\name{extract_examples}
\alias{extract_examples}
\title{Extract examples lines from a roxygen-documented .R file.}
\usage{
extract_examples(r_file_name, pkg_dir = ".")
}
\arguments{
\item{r_file_name}{The name of the .R file within R/. Don't specify this as
"R/x.R", just use "x.R" for whichever file x it is. You can also omit the
.R for convenience, however using the wrong case (e.g. .r) will produce an
error. If instead, you wish to set the full path to the file here, set
\code{pkg_dir} to \code{NULL}.}

\item{pkg_dir}{The directory of the R project for this package (defaults to
current directory). Note that this is the parent directory of R/. If you
want to specify the full file path in the \code{r_file_name} argument, set
\code{pkg_dir} to \code{NULL}.}
}
\value{
A charachter vector.
}
\description{
In each .R file in the R/ folder of a pcakage project, there can be examples
within documented via the \link[roxygen2:roxygen2]{roxygen2} under the
\code{@examples} roxygen tag.
}
\details{
Anything examples found within a \code{\\dontrun\{...\}} block are ignored.
}
\examples{
setwd(tempdir())
if (dir.exists("tempkg")) warning("Do not proceed, you'll mess with your ",
"'tempkg' folder.")
dir.create("tempkg")
devtools::create("tempkg")
setwd("tempkg")
file.copy(system.file("extdata", "exemplar.R", package = "exampletestr"), "R")
extract_examples("exemplar")
extract_examples("exemplar")
setwd("..")
filesstrings::RemoveDirs("tempkg")
\dontrun{
extract_examples("non_existent_file")}

}
