% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_density_2D}
\alias{plot_density_2D}
\title{Density plot in 2D, considering Start time and Connection duration as variables}
\usage{
plot_density_2D(
  sessions,
  bins = 15,
  by = c("wday", "month", "year"),
  start = getOption("evprof.start.hour"),
  log = FALSE
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{bins}{integer, parameter to pass to \code{ggplot2::stat_density_2d}}

\item{by}{variable to facet the plot. Character being "wday", "month" or "year", considering the week to start at wday=1.}

\item{start}{integer, start hour in the x axis of the plot.
This is only used when \code{log = FALSE}.}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}
}
\value{
ggplot2 plot
}
\description{
Density plot in 2D, considering Start time and Connection duration as variables
}
\examples{
library(dplyr)

california_ev_sessions \%>\%
  sample_frac(0.1) \%>\%
  plot_density_2D(by = "wday", start = 3, bins = 15, log = FALSE)

}
