% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.credpart.R
\name{predict.credpart}
\alias{predict.credpart}
\title{Computation of a credal partition for new data}
\usage{
\method{predict}{credpart}(object, newdata, fhat = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"credpart"}, encoding a credal partition.}

\item{newdata}{A matrix of size ntest*p containing the new data.}

\item{fhat}{An optional vector of one-class SVM outputs (for method nn-evclus only)}

\item{...}{Additional arguments (not used).}
}
\value{
A credal partition of the new data.
}
\description{
\code{predict.credpart} is the \code{predict} method for \code{"credpart"} 
objects generated by \code{nnevclus} or \code{ecm}.
}
\details{
This function computes a credal partial of newdata based on learnt information stored 
in a \code{"credpart"} objects created by \code{\link{ecm}} or \code{\link{nnevclus}}.
}
\examples{
\dontrun{
data(fourclass)
train<-sample(400,200)
x<-fourclass[train,1:2]
x.test<-x[-train,1:2]
clus<-ecm(x,c=4,type='pairs',delta=sqrt(10),epsi=1e-3,disp=TRUE)
clus.test<-predict(clus,x.test)
plot(clus.test,x.test,mfrow=c(2,2))
}
}
\references{
T. Denoeux and O. Kanjanatarakul. Beyond Fuzzy, Possibilistic and Rough: An
Investigation of Belief Functions in Clustering. 8th International conference on soft
methods in probability and statistics, Rome, 12-14 September, 2016.

M.-H. Masson and T. Denoeux. ECM: An evidential version of the fuzzy c-means algorithm.
Pattern Recognition, Vol. 41, Issue 4, pages 1384--1397, 2008.

T. Denoeux, S. Sriboonchitta and O. Kanjanatarakul. Evidential clustering of large
dissimilarity data. Knowledge-Based Systems, vol. 106, pages 179-195, 2016.
}
\seealso{
\code{\link{ecm}}, \code{\link{cecm}}, \code{\link{nnevclus}}.
}
