% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{etrd_get_url}
\alias{etrd_get_url}
\title{Get request for a specific URL}
\usage{
etrd_get_url(etrade_url, access_tokens, etrade_cred)
}
\arguments{
\item{etrade_url}{The URL for the get request}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}
}
\value{
content of the GET request
}
\description{
Some functions may return a URL (for example \code{\link{etrd_option_chain}})
that requires a further GET request. This function can return the contents.
The access token and etrade credentials must be explicitly passed.
}
\examples{
\dontrun{

etrd_get_url('https://api.etrade.com/v1/market/quote/SPY:2020:11:20:PUT:185.000000',
             access_tokens, etrade_cred)

}
}
