% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_MGamma.R
\name{dmgamma}
\alias{dmgamma}
\alias{rmgamma}
\title{The Multivariate Gamma Distribution}
\usage{
dmgamma(x, shape, scale, log = FALSE)

rmgamma(n, shape, scale)
}
\arguments{
\item{x}{numeric. The quantile vector.}

\item{shape}{numeric. The shape parameter vector.}

\item{scale}{numeric. The scale parameter vector.}

\item{log}{logical. If \code{TRUE}, probabilities \code{p} are given as \code{log(p)}.}

\item{n}{numeric. The number of observations.}
}
\value{
\code{dmgamma} returns a numeric vector (the evaluated density function).
\code{rmgamma} returns a matrix with \code{length(shape)} rows and \code{n} columns.
}
\description{
Density function and random generation for the Multivariate Gamma
distribution with shape parameter vector \code{shape} and scale parameter \code{scale}.
}
\examples{
# Classic R Stats Format
dmgamma(c(4, 6), shape = c(2, 3), scale = 2)
set.seed(1)
rmgamma(10, shape = c(2, 3), scale = 2)

# S4 Distribution Class
library(distr)
D <- MGamma(shape = c(2, 3), scale = 2)
d(D)(c(4, 6))
set.seed(1)
r(D)(10)
}
