% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesting_cube.R
\name{nesting.cube}
\alias{nesting.cube}
\title{Restriction of a volume to a rectangular parallelepiped}
\usage{
nesting.cube(obj, pt.min, pt.max, alias = "", description = NULL, ...)
}
\arguments{
\item{obj}{object of class volume or mesh.}

\item{pt.min}{minimum x, y, z coordinates of the rectangular parallelepiped vertex.}

\item{pt.max}{maximum x, y, z coordinates of the rectangular parallelepiped vertex.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the the created object. If
the \code{description = NULL} (default value), it will be set to \code{obj$description}.}

\item{...}{Additional arguments \code{vol} (depracated), replaced by \code{obj}.}
}
\value{
Returns a "volume" class object, in which 3D volume is restricted
or increased to be circumscribed to the requested rectangular parallelepiped.
If the created volume exceeds the initial volume, new voxels are set to \code{NA}.
}
\description{
The \code{nesting.cube} function restricts or increases
a volume to the rectangular parallelepiped defined by its 2 extreme vertices.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 5
patient <- toy.load.patient (modality = "ct", roi.name = "", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
# Calculation of the new CT restricted to the parallelepiped reduced by 10 mm.
pt.CT <- get.extreme.pt (CT) # extreme points of CT
new.pt.CT <- pt.CT + matrix (rep (c (+ 12, -12), 3), ncol = 2, byrow = TRUE)
new.CT <- nesting.cube (CT, new.pt.CT$min, new.pt.CT$max, alias = "new CT")
\dontrun{  
# check for change
display.3D.stack (CT)
display.3D.stack (new.CT, line.col="red")
}
}
\seealso{
\link[espadon]{add.margin}, \link[espadon]{nesting.roi} and
\link[espadon]{nesting.bin}.
}
