% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_obj_connection.R
\name{get.obj.connection}
\alias{get.obj.connection}
\title{List of connections between objects}
\usage{
get.obj.connection(pat)
}
\arguments{
\item{pat}{"patient" class object, as loaded using \link[espadon]{load.patient.from.dicom},
\link[espadon]{load.patient.from.Rdcm} or \link[espadon]{toy.load.patient}.}
}
\value{
Returns a list of 4 named matrices:
\itemize{
\item the \code{$adjacency} matrix matrix specifies the source objects that
generated the destination objects: the column names correspond to the
destinations, and the row names to the sources.
\item the \code{$same.object} matrix specifies the elements belonging to the same
DICOM object.
\item the \code{$components} matrix specifies the objects belonging to the same study.
\item the \code{$same.ref} matrix specifies the objects that share the same frame of
reference, or with frames of reference linked in T.MAT (by a DICOM reg file
for instance)
}
}
\description{
The \code{get.obj.connection} function describes with 4 matrices
the different connections between the DICOM objects of the patient.
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (dxyz = c (5, 5, 5), beam.nb = 1)
get.obj.connection (patient)
display.obj.links (patient)
}
\seealso{
\link[espadon]{display.obj.links}
}
