% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_3D_contour.R
\name{display.3D.contour}
\alias{display.3D.contour}
\title{Display the 3D contours of the RoI}
\usage{
display.3D.contour(
  struct,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  roi.col = NULL,
  roi.print = FALSE,
  roi.lwd = 1,
  roi.cex = 1,
  display.ref = struct$ref.pseudo,
  T.MAT = NULL,
  FoR.axis = FALSE,
  FoR.col = "black"
)
}
\arguments{
\item{struct}{"struct" class object. See \link[espadon]{espadon.class} for
class definitions.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the \code{struct} object.
By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct} object.
By default \code{roi.idx = NULL}. See Details.}

\item{roi.col}{Color of the RoI. If \code{roi.col = NULL} (default),the RoI
colors are specified in the \code{struct$roi.info}.}

\item{roi.print}{Boolean vector indicating whether to display the pseudonym
of the RoI.}

\item{roi.lwd}{Line width of the RoI, by default at 1.}

\item{roi.cex}{Numeric character expansion factor of RoI name if
\code{roi.print = TRUE}, defaults to 1.}

\item{display.ref}{Pseudonym of frame of reference of the display.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm} or
\link[espadon]{load.T.MAT}. If \code{T.MAT = NULL}, \code{display.ref} must be equal to \code{NULL} or to
\code{struct$ref.pseudo}.}

\item{FoR.axis}{Boolean or numeric, by default set to \code{FALSE}. If \code{FoR.axis = TRUE},
the function displays 200 mm length director vectors of the frame of reference.
If \code{FoR.axis} is numeric, it represent the length in mm of the director vectors.}

\item{FoR.col}{Color of the frame of reference.}
}
\value{
If the concerned regions of interest (RoI) \code{struct} exist,
it displays the 3D contours of these RoI in the current \pkg{RGL} window if it exists,
in a new window otherwise.
}
\description{
The \code{display.3D.contour} function performs a 3D display of the selected RoI in the chosen coordinate system.
}
\details{
If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are all
\code{NULL}, then all of the RoI are selected.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "rtstruct", roi.name = "eye",
                             dxyz = rep (step, 3))
library (rgl)
open3d()
bg3d ("black")
display.3D.contour (struct = patient$rtstruct[[1]], roi.print = TRUE)
}
