% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_patient_anonymiser.R
\name{dicom.patient.anonymiser}
\alias{dicom.patient.anonymiser}
\title{Anonymisation of a patient's DICOM files}
\usage{
dicom.patient.anonymiser(
  dcm.files,
  pat.dest.dir,
  offset = 0,
  new.PIN = "Anonymous patient",
  reset.private.tag = FALSE,
  tag.dictionary = dicom.tag.dictionary(),
  verbose = TRUE
)
}
\arguments{
\item{dcm.files}{String vector, representing the list of the full names of the
DICOM files of the same patient, or its directories.}

\item{pat.dest.dir}{Character string,representing the full name of the patient's
directory, which will contain the patient's anonymized files.}

\item{offset}{Integer, default to 0. Each date of the DICOM will be shifted
by this offset expressed in days.}

\item{new.PIN}{Character string, representing the PIN remplacing the old one.}

\item{reset.private.tag}{Boolean, if \code{TRUE}, the value of tags that are
not in the \code{tag.dictionary} is removed.}

\item{tag.dictionary}{Dataframe, by default equal to
\link[espadon]{dicom.tag.dictionary}, whose structure it must keep. This
dataframe is used to parse DICOM files.}

\item{verbose}{Boolean. If \code{TRUE}, a progress bar indicates loading progress.}
}
\value{
Creation of the \code{pat.dest.dir} directory, with anonymous DICOM files
}
\description{
the \code{dicom.patient.anonymiser} function anonymises all DICOM
files in a patient's directory.
}
\note{
The files are anonymized as follows:
\itemize{
\item Each date of the DICOM file will be shifted by \code{offset} expressed in days.
\item Each patient's name, and patient'ID are remplaced by \code{new.PIN}
\item All other patient data are deleted, except age, weight, height, gender
and shifted birthday.
\item All address, phone, physician, operator, author, reviewer, service.
\item If \code{reset.private.tag = TRUE}, the values of the tags not contained
in the \code{tag.dictionary} are deleted.
}
File names are composed of their modality and the SOP UID.
}
\examples{
# First, save toy.dicom.raw () raw data to a temporary file pat.dir for testing.
temp <- tempdir()
pat.dir <- file.path (temp, "toy_dcm") 
dir.create (pat.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "toyrtplan", tmpdir = pat.dir,
                          fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)

# Files anonymisation
anonymous.pat.dir <- file.path (temp, "anonymous") 
dicom.patient.anonymiser (dcm.files = pat.dir, pat.dest.dir = anonymous.pat.dir,
                          offset = 0, new.PIN = "Anonymous patient",
                          reset.private.tag = TRUE)
lf <- list.files(anonymous.pat.dir, full.names = TRUE)  
dp <- dicom.parser(lf[1])   
dp[grep("^[(]0008|^[(]0010", dp$TAG),]       

# Cleaning  temporary directory
unlink (pat.dir, recursive = TRUE)            
}
