% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export espadon objects in dicom format}
\usage{
export(
  obj,
  format = "dcm",
  ref.obj.list = NULL,
  use.original.UIs = FALSE,
  use.original.ref.UIs = TRUE,
  file.prefix = "",
  file.dirname = ".",
  file.name = NULL,
  tag.dictionary = dicom.tag.dictionary(),
  ...
)
}
\arguments{
\item{obj}{espadon object of rtstruct, ct or rtdose modality to be exported.}

\item{format}{Format of the export. For next use.}

\item{ref.obj.list}{List of espadon objects which are referenced objects of \code{obj}. See Details.}

\item{use.original.UIs, use.original.ref.UIs}{Booleans. If \code{TRUE}, study instance UID, serie instance
UID and image type attribute are those indicated in \code{$object.info} item.
Otherwise,They are regenerated. See Details.}

\item{file.prefix}{String. Prefix added to the generated filename, in case of \code{file.name} is \code{NULL}.}

\item{file.dirname}{String. Name of the directory in which files are generated.}

\item{file.name}{String. Base name of the generated files. in CT modality, a slice number is added as a suffix.}

\item{tag.dictionary}{Dataframe, by default equal to
\link[espadon]{dicom.tag.dictionary}, whose structure it must keep. This
dataframe is used to parse DICOM files.}

\item{...}{Additional settings such as NAvalue (for "volume" data), '(0020,000D)',
'(0020,000E)', '(0008,0008)'}
}
\value{
Returns nothing, but generate DICOM files if conditions are required,
and indicates the name or number of files created
}
\description{
The \code{export} function exports struct class objects and
volume class objects with CT or RTDOSE modality in DICOM format.
}
\details{
The object you want to export may be known in a TPS thanks to these
Unique Identifiers (UIs). If you want to create a DICOM object that is different
and recognised by your TPS, it is important that the DICOM files you want to
create have new UIs: in this case, set the \code{use.original.UIs} argument
to \code{FALSE}. Otherwise, UIs in \code{$object.info} item of your object
will be used.

Your object may have been created from another DICOM object (i.e. a
reference object). You can, for example, see these links with the function
\link[espadon]{display.obj.links}.

If you want to keep this links, you must indicate which objects are
references in the \code{ref.obj.list} argument, in the form of a list of espadon
objects. If these reference objects have their own identifier and you wish to
keep them, you must set the \code{use.original.ref.UIs} argument to \code{TRUE}.

Otherwise (\code{use.original.ref.UIs=FALSE}), the UIs of the reference
objects will be regenerated. It is therefore important that the reference objects
contain all their data such as \code{vol3D.data} or \code{roi.data}.

It may be useful to impose a study number (tag '(0020,000D)'), serial
number (tag '(0020,000E)'), or your Image Type Attribute (tag '(0008,0008)').
In this case, you need to add the arguments \code{'(0020,000D)' = your_study_UID},
\code{'(0020,000E)' = your_serial_UID}, \code{'(0008,0008)' = your_image_type_attribute}.
}
\examples{
# First, save toy patient objects to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "", 
                             dxyz = c (6, 6, 6))
dicom.dir <- file.path (tempdir(), "PM_dcm") 
export(patient$rtstruct[[1]], ref.obj.list = list (patient$ct[[1]]),
       file.dirname = dicom.dir,file.name="RS")
export(patient$ct[[1]], file.dirname = dicom.dir,file.name="CT")
list.files(dicom.dir)

# check that the links have been preserved.
pat <- load.patient.from.dicom (dicom.dir, verbose = FALSE)
display.obj.links (pat)

# Cleaning  temporary directories
unlink (dicom.dir, recursive = TRUE)

}
