% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_mean_sd.R
\name{esc_mean_sd}
\alias{esc_mean_sd}
\title{Compute effect size from Mean and Standard Deviation}
\usage{
esc_mean_sd(grp1m, grp1sd, grp1n, grp2m, grp2sd, grp2n, totalsd,
  es.type = c("d", "g", "or", "logit", "r", "cox.or", "cox.log"),
  study = NULL)
}
\arguments{
\item{grp1m}{The mean of the first group.}

\item{grp1sd}{The standard deviation of the first group.}

\item{grp1n}{The sample size of the first group.}

\item{grp2m}{The mean of the second group.}

\item{grp2sd}{The standard deviation of the second group.}

\item{grp2n}{The sample size of the second group.}

\item{totalsd}{The full sample standard deviation. Either \code{grp1sd} and
\code{grp2sd}, or \code{totalsd} must be specified.}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{esc_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{esc_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
}}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size from mean and either group-based standard
             deviations or full sample standard deviation.
}
\note{
If \code{es.type = "r"}, Fisher's transformation for the effect size
      \code{r} and their confidence intervals are also returned.
}
\examples{
# with standard deviations for each group
esc_mean_sd(grp1m = 7, grp1sd = 2, grp1n = 50,
            grp2m = 9, grp2sd = 3, grp2n = 60, es.type = "logit")

# with full sample standard deviations
esc_mean_sd(grp1m = 7, grp1n = 50, grp2m = 9, grp2n = 60, totalsd = 4)

}
\references{
Lipsey MW, Wilson DB. 2001. Practical meta-analysis. Thousand Oaks, Calif: Sage Publications
            \cr \cr
            Wilson DB. 2016. Formulas Used by the "Practical Meta-Analysis Effect Size Calculator". Unpublished manuscript: George Mason University
}

