% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cn.R
\name{cn}
\alias{cn}
\title{Customizable Number Aware String}
\usage{
cn(n, one = "there \%r \%n value\%s", some = one, none = some,
  lots = some, nlots = 10)
}
\arguments{
\item{n}{A count of the number.}

\item{one}{The string to return if \code{n = 1}}

\item{some}{The string to return if n is in \code{2, 3, ..., nlots - 1}}

\item{none}{The string to return if \code{n = 0}}

\item{lots}{The string to return if \code{n >= nlots}}

\item{nlots}{A count of the number of values to consider to be lots}
}
\value{
A string of the updated message.
}
\description{
Customizable Number Aware String
}
\section{\code{sprintf}-like types}{

The following \code{sprintf}-like types can be used in the custom messages:

\describe{
  \item{\code{n}}{the length of the object}
  \item{\code{s}}{'s' if n != 1 otherwise ''}
}
}

\examples{
cn(0)
cn(1)
cn(4)
}
\seealso{
\code{\link{cc}} and \code{\link{co}}
}
