% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2degrange-ergmTerm}
\alias{b2degrange-ergmTerm}
\alias{InitErgmTerm.b2degrange}
\title{Degree range for the second mode in a bipartite network}
\usage{
# binary: b2degrange(from, to=+Inf, by=NULL, homophily=FALSE, levels=NULL)
}
\arguments{
\item{from, to}{vectors of distinct integers. If one of the vectors have length 1, it is recycled to the length of the other. Otherwise, it must have the same length.}

\item{by, levels, homophily}{the optional argument \code{by} specifies a vertex attribute (see Specifying
Vertex attributes and Levels (\code{?nodal_attributes}) for details).
If this is specified and \code{homophily} is \code{TRUE} ,
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
If \code{by} is specified and
\code{homophily} is \code{FALSE} (the default), then separate degree range
statistics are calculated for nodes having each separate
value of the attribute. \code{levels} selects which levels of by` to include.}
}
\description{
This term adds one
network statistic to the model for each element of \code{from} (or \code{to} ); the \eqn{i} th
such statistic equals the number of nodes of the second mode
("events") in the network of degree greater than or equal to
\code{from[i]} but strictly less than \code{to[i]} , i.e. with edge count
in semiopen interval \verb{[from,to)} .

This term can only be used with bipartite networks; for directed networks
see \code{idegrange} and \code{odegrange} . For undirected networks,
see \code{degrange} , and see \code{b1degrange}
for degrees of the first mode ("actors").
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2degrange", "subsection")}
}
\concept{bipartite}
\concept{undirected}
