% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marg_cond_sim.R
\name{marg_cond_sim}
\alias{marg_cond_sim}
\title{Calculate gofN()-style Pearson residuals for arbitrary statistics}
\usage{
marg_cond_sim(
  object,
  nsim = 1,
  obs.twostage = nsim/2,
  GOF = NULL,
  control = control.gofN.ergm(),
  save_stats = FALSE,
  ...
)
}
\arguments{
\item{object}{an \code{\link{ergm}} object.}

\item{nsim}{number of realizations.}

\item{obs.twostage, GOF, save_stats}{see \code{\link[=gofN]{gofN()}}.}

\item{control}{a control list returned by \code{\link[=control.gofN.ergm]{control.gofN.ergm()}}; note that \code{nsim} and \code{obs.twostage} parameters in the control list are ignored in favor of those passed to the function directly.}

\item{...}{additional arguments to \code{\link[=ergm_model]{ergm_model()}}, \code{\link[=simulate.ergm]{simulate.ergm()}}, and \code{\link[=summary.ergm_model]{summary.ergm_model()}}.}
}
\value{
an object of similar structure as that returned by \code{\link[=gofN]{gofN()}}.
}
\description{
This function is to be considered experimental. Do NOT rely on
it. It may, eventually, be moved to \code{ergm}, perhaps integrated into
the \code{simulate} methods.
}
