% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{get_idf_node_relation}
\alias{get_idf_node_relation}
\title{Extract node relations}
\usage{
get_idf_node_relation(
  idd_env,
  idf_env,
  object_id = NULL,
  value_id = NULL,
  object = NULL,
  class = NULL,
  group = NULL,
  name = FALSE,
  keep_all = FALSE,
  depth = 0L
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{object_id}{An integer vector of valid object IDs. If \code{NULL}, all object
IDs in current IDF will be used.}

\item{value_id}{An integer vector of valid value IDs. If \code{NULL}, all value
IDs in current IDF will be used.}

\item{object}{An integer vector of valid object IDs or a character vector
of valid object names to specify the targeting relation objects.
Default: \code{NULL}.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names to specify the targeting relation classes.
Default: \code{NULL}.}

\item{group}{A character vector of valid group names to specify the targeting
relation groups. Default: \code{NULL}.}

\item{name}{If \code{TRUE}, all class, object, field value ID and name columns
will be added and a \code{IdfRelationTo} or \code{IdfRelationBy} object is
returned with customized printing method. Default: \code{FALSE}.}

\item{keep_all}{If \code{TRUE}, all input ID are kept. Otherwise, only input IDs
that have relations are kept. Default: \code{FALSE}.}

\item{depth}{Recursive reference relation depth. \code{NULL} means infinite.
Default: \code{0L}.}
}
\value{
A data.table.
}
\description{
Extract node relations
}
\keyword{internal}
