% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{expand_idf_dots_literal}
\alias{expand_idf_dots_literal}
\title{Parse object values given in literal character vectors or data.frames}
\usage{
expand_idf_dots_literal(idd_env, idf_env, ..., .default = TRUE, .exact = FALSE)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{...}{Character vectors or data.frames.}

\item{.default}{If \code{TRUE}, all empty fields will be filled with default
values if possible. Default: \code{TRUE}.}

\item{.exact}{If \code{TRUE}, all inputs should match existing objects in the
\link{Idf}. In this case, \code{id} column is require for data.frame input.
Default: \code{FALSE}.}
}
\value{
A named list of 2 element \code{object} and \code{value} which is a
\code{\link[data.table:data.table]{data.table::data.table()}} with object data and value data respectively.
}
\description{
Parse object values given in literal character vectors or data.frames
}
\details{
For object definitions in character vector format, they follow the
same rules as a normal IDF file:
\itemize{
\item Each object starts with a class name and a comma (\verb{,});
\item Separates each values with a comma (\verb{,});
\item Ends an object with a semicolon (\verb{;}) for the last value.
}

Each character vector can contain:
\itemize{
\item One single object, e.g. \code{c("Building,", "MyBuilding;")}, or "Building, MyBuilding;".
\item Multiple objects, e.g. \code{c("Building, MyBuilding;", "SimulationControl, Yes")}.
}

You can also provide an option header to indicate if input objects are
presented in IP units, using \verb{!-Option ViewInIPunits}. If this header does
not exist, then all values are treated as in SI units.

For object definitions in data.frame format, a valid definition requires at
least three columns described below. Note that column order does not matter.
\itemize{
\item \code{class}:Character type. Valid class names in the underlying
\link{Idd} object.
\item \code{index}:Integer type. Valid field indices for each class.
\item \code{value}:Character type or list type. Value for each field
to be added.
\itemize{
\item If character type, each value should be given as a string even if the
corresponding field is a numeric type.
\item If list type, each value should have the right type as the corresponding
field definition.
}
\item \code{id}: \strong{Optional} when \code{.exact} is \code{FALSE}. Integer type.
If input data.frame includes multiple object definitions in a same class,
values in \code{id} column will be used to distinguish each definition. If \code{id}
column does not exists, it assumes that each definition is separated by
\code{class} column and will issue an error if there is any duplication in the
\code{index} column.
}
}
\note{
Objects from character vectors will always be at the top of each table.
}
\keyword{internal}
