% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdd.R
\name{rdd_to_load}
\alias{rdd_to_load}
\alias{mdd_to_load}
\title{Format RddFile Object to Standard Input for \code{Idf$load()} Method}
\usage{
rdd_to_load(rdd, key_value, reporting_frequency)

mdd_to_load(
  mdd,
  reporting_frequency,
  class = c("Output:Meter", "Output:Meter:MeterFileOnly", "Output:Meter:Cumulative",
    "Output:Meter:Cumulative:MeterFileOnly")
)
}
\arguments{
\item{rdd, mdd}{A \code{RddFile} object created using \code{\link[=read_rdd]{read_rdd()}} and a \code{MddFile}
object created using \code{\link[=read_mdd]{read_mdd()}}, respectively.}

\item{key_value}{Key value name for \strong{all} variables. If not specified and
the \code{key_value} column in the input \code{RddFile} object will be used. If
\code{key_value} column does not exist, \code{"*"} are used for all variables.}

\item{reporting_frequency}{Variable value reporting frequency for \strong{all}
variables. If not specified and the \code{reporting_freqency} column in the input
\code{RddFile} object will be used. If \code{reporting_freqency} column does not exist,
\code{"Timestep"} are used for all variables. All possible values: \code{"Detailed"},
\code{"Timestep"}, \code{"Hourly"}, \code{"Daily"}, \code{"Monthly"}, \code{"RunPeriod"},
\code{"Environment"}, and \code{"Annual"}.}

\item{class}{Class name for meter output. All possible values:
\code{"Output:Meter"}, \code{"Output:Meter:MeterFileOnly"},
\code{"Output:Meter:Cumulative"}, and \code{"Output:Meter:Cumulative:MeterFileOnly"}.
Default: \code{"Output:Meter"}.}
}
\value{
A \link[data.table:data.table]{data.table} with 5 columns with an additional
attribute named \code{eplus_version} extracted from the original \code{RddFile} and
\code{MddFile}:
\itemize{
\item \code{id}: Integer type. Used to distinguish each object definition.
\item \code{class}: Character type. Class names, e.g. \code{Output:Variable} and
\code{Output:Meter}.
\item \code{index}: Integer type. Field indices.
\item \code{field}: Character type. Field names.
\item \code{value}: Character type. The value of each field to be added.
}
}
\description{
\code{rdd_to_load()} and \code{mdd_to_load()} takes a \code{RddFile} and \code{MddFile} object
respectively and format it into a \link[data.table:data.table]{data.table} in
acceptable format for \verb{$load()} method in \link{Idf} class.
}
\examples{
\dontrun{
# read an example distributed with eplusr
path_idf <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr")
idf <- read_idf(path_idf)

# run Design-Day-Only simulation silently
job <- idf$run(NULL, tempdir(), echo = FALSE)

# read RDD and MDD
rdd <- job$read_rdd()
mdd <- job$read_mdd()

# perform subsetting on the variables
# e.g.:
rdd_sub <- rdd[grepl("Site", variable)]
mdd_sub <- mdd[grepl("Electricity", variable)]

# use newly added helper `rdd_to_load()` and `mdd_to_load()` and `$load()` to
# add `Output:Variable` and `Output:Meter*`
idf$load(rdd_to_load(rdd_sub))
idf$load(mdd_to_load(mdd_sub))

# default `Key Value` is `"*"` and `Reporting Frequency` is `Timestep`
# can overwrite using `key_value` and `reporting_freqency` arg
rdd_to_load(rdd_sub, key_value = "Environment", reporting_frequency = "hourly")

# if input has column `key_value`, default is to use it, unless `key_value` is
# explicitly specified
rdd_to_load(rdd_sub[, key_value := "Environment"])
rdd_to_load(rdd_sub[, key_value := "Environment"], key_value = "*")

# `reporting_frequency` arg works in the same way as `key_value` arg, i.e.:
# if input has column `reporting_frequency`, use it, unless
# `reporting_frequency` is explicitly specified
rdd_to_load(rdd_sub[,  reporting_frequency := "monthly"])
rdd_to_load(rdd_sub[,  reporting_frequency := "monthly"], reporting_frequency = "detailed")

# if input has column `key_value`, default is to use it, unless `key_value` is
# explicitly specified
rdd_to_load(rdd_sub[, key_value := "Environment"])
rdd_to_load(rdd_sub[, key_value := "Environment"], key_value = "*")

# meter class can be further specified using `class` arg
mdd_to_load(mdd_sub, class = "Output:Meter:MeterFileOnly")
}
}
