% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{dup_idf_object}
\alias{dup_idf_object}
\title{Duplicate existing objects}
\usage{
dup_idf_object(
  idd_env,
  idf_env,
  dt_object,
  level = eplusr_option("validate_level")
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{dt_object}{A \code{\link[data.table:data.table]{data.table::data.table()}} that contains object data.}

\item{level}{Validate level. Default: \code{eplusr_option("validate_level")}.}
}
\value{
The modified \link{Idf} data in a named list of 5 elements, i.e. \code{object},
\code{value}, \code{reference}, \code{changed} and \code{updated}. First 3 elements are
\code{\link[data.table:data.table]{data.table::data.table()}}s containing the actual updated \link{Idf} data while
\code{changed} and \code{updated} are integer vectors containing IDs of objects that
have been directly changed and indirectly updated due to references,
respectively.
}
\description{
Duplicate existing objects
}
\keyword{internal}
