% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epirt.R
\name{scaled_logit}
\alias{scaled_logit}
\title{Represents a 'scaled' logit link}
\usage{
scaled_logit(K = 6)
}
\arguments{
\item{K}{parameterises the link function. The inverse of which then
takes values between 0 and K.}
}
\value{
A list with class "scaled_logit"
}
\description{
The link function is parameterised by a value \eqn{r>0}, and takes
the form
\eqn{log(x/(K - x))}.
The inverse link is then
\eqn{K* inv_logit(x)}.
This is similar to the logit link, although x can range between
\eqn{[0, K]} rather than \eqn{[0,1]}. The parameter K can be chosen.
}
