% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{robust_outcome}
\alias{robust_outcome}
\title{Implements the robust modified outcome approach}
\usage{
robust_outcome(A, X, Y, propensity, parallel = FALSE, ...)
}
\arguments{
\item{A}{target variant}

\item{X}{rest of the genotype}

\item{Y}{phenotype}

\item{propensity}{propensity scores}

\item{parallel}{whether to perform support estimation in a
parallelized fashion}

\item{...}{additional arguments to be passed to \code{stabilityGLM} or
\code{stabilityBIG}}
}
\value{
a vector containing the area under the stability selection path for
  each variable in \code{X}
}
\description{
A key feature of \code{robust_outcome} is its resilience to the misspecification
of propensity scores, which is a major limitation of classical
modified outcome approaches.
Except for \code{shifted_outcome}, all of
the modified outcome approaches belong to a parameterized class of unbiased
estimators for the risk difference term
\eqn{E\left[Y| A=1,X\right]-E\left[Y| A=0,X\right]}{E[Y|A=1,X]-E[Y|A=0,X]}.
Within that class, robust modified outcome is the approach with the least
large-sample variance. For more details about this approach, see Lunceford
and Davidian (2004)
}
\examples{
n <- 30
p <- 10
X <- matrix((runif(n * p) < 0.4) + (runif(n * p) < 0.4),
             ncol = p, nrow = n) # SNP matrix
A <- rbinom(n, 1, 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- runif(n) < 0.4
robust_scores <- robust_outcome(A, X, Y, propensity,
                               lambda_min_ratio = 0.01 , n_subsample = 1)

}
\references{
Lunceford, J. K., & Davidian, M. (2004). Stratification and
weighting via the propensity score in estimation of causal treatment effects:
A comparative study. Statistics in Medicine, 23(19), 2937–2960.
}
