% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{normalized_outcome}
\alias{normalized_outcome}
\title{Implements the normalized modified outcome approach}
\usage{
normalized_outcome(A, X, Y, propensity, parallel = FALSE, ...)
}
\arguments{
\item{A}{target variant}

\item{X}{rest of the genotype}

\item{Y}{phenotype}

\item{propensity}{propensity scores}

\item{parallel}{whether to perform support estimation in a
parallelized fashion}

\item{...}{additional arguments to be passed to \code{stabilityGLM} or
\code{stabilityBIG}}
}
\value{
a vector containing the area under the stability selection path for
  each variable in \code{X}
}
\description{
Normalized modified outcome is an improvement to \code{\link{modified_outcome}}.
Its large-sample variance is lower than the original modified outcome approach.
The only difference between the two methods lies in the normalization of the
propensity scores. The inverses of the propensity scores
\eqn{1/\pi(A=1| X)}{1/P(A=1|X)} and \eqn{1/\pi(A=0| X)}{1/P(A=0|X)} are
respectively normalized by their sum
\eqn{\sum_{i} 1/\pi(A_i=1| X_i)}{sum _i 1/P(A_i=1|X_i)} and
\eqn{\sum_{i} 1/\pi(A_i=0| X_i)}{sum _i 1/P(A_i=0|X_i)}.
}
\examples{
n <- 30
p <- 10
X <- matrix((runif(n * p) < 0.5) + (runif(n * p) < 0.5),
             ncol = p, nrow = n) # SNP matrix
A <- (runif(n) < 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- runif(n) < 0.4
normalized_scores <- normalized_outcome(A, X, Y, propensity,
                               lambda_min_ratio = 0.02 , n_subsample = 1)

}
