% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.r
\name{ENsetqualtype}
\alias{ENsetqualtype}
\title{Set the type of water quality analysis called for.}
\usage{
ENsetqualtype(qualcode, chemname = "", chemunits = "", tracenode = "")
}
\arguments{
\item{qualcode}{An integer or a character string, the water quality analysis code (see below).}

\item{chemname}{A character string, the name of the chemical being analyzed.}

\item{chemunits}{A character string, units that the chemical is measured in.}

\item{tracenode}{A character string, ID of node traced in a source tracing analysis.}
}
\value{
returns NULL invisibly on success
}
\description{
\code{ENsetqualtype} sets the type of water quality analysis called for.
}
\details{
Water quality analysis codes are as follows:

  \tabular{lrl}{
  \code{EN_NONE}			\tab 	0	\tab No quality analysis\cr
  \code{EN_CHEM}			\tab	1	\tab Chemical analysis\cr
  \code{EN_AGE}			\tab	2	\tab Water age analysis\cr
  \code{EN_TRACE}		\tab	3	\tab Source tracing
  }

  Chemical name and units can be an empty string if the analysis is not for a chemical.   
  The same holds for the trace node if the analysis is not for source tracing. 
  Note that the trace node is specified by ID and not by index.
}
\examples{
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetqualtype()
ENsetqualtype("EN_CHEM", "Chlorine", "mg/L", "")
ENgetqualtype()
ENclose()
}
\seealso{
\code{ENgetqualtype}
\url{http://wateranalytics.org/EPANET/group___quality_functions.html}
}
