% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.r
\name{ENsetcontrol}
\alias{ENsetcontrol}
\title{Set the parameters of a simple control statement}
\usage{
ENsetcontrol(cindex, ctype = NULL, lindex = NULL, setting = NULL,
  nindex = NULL, level = NULL)
}
\arguments{
\item{cindex}{Integer, control statement index}

\item{ctype}{Integer or character string, the control type code (see Details below).}

\item{lindex}{Integer, index of the link being controlled.}

\item{setting}{Numeric, value of the control setting.}

\item{nindex}{Integer, the index of the controlling node.}

\item{level}{value of controlling water level or pressure for level controls or of
time of control action (in seconds) for time-based controls}
}
\value{
Returns NULL invisibly on success or raises an error or warning.
}
\description{
\code{ENsetcontrol} sets the parameters of a simple control statements.
}
\details{
Controls are indexed starting from 1 in the order in which they were entered into the
  \code{[CONTROLS]} section of the EPANET input file.
  Control type codes consist of the following:

  \tabular{lll}{
		\code{EN_LOWLEVEL}  \tab  0  \tab  Control applied when tank level or node pressure\cr
       					\tab  	 \tab    drops below specified level\cr
		\code{EN_HILEVEL}   \tab  1  \tab  Control applied when tank level or node pressure\cr
						\tab	 \tab  rises above specified level\cr
		\code{EN_TIMER}     \tab  2  \tab  Control applied at specific time into simulation\cr
		\code{EN_TIMEOFDAY} \tab  3  \tab  Control applied at specific time of day
  }
  For pipes, a \code{setting} of 0 means the pipe is closed and 1 means it is open. For a
  pump, the \code{setting} contains the pump's speed, with 0 meaning the pump is closed and
 1 meaning it is open at its normal speed. For a valve, the \code{setting} refers to the valve's
  pressure, flow, or loss coefficient, depending on valve type.

  For Timer or Time-of-Day controls set the \code{nindex} parameter to 0.

  For level controls, if the controlling node \code{nindex} is a tank then the level parameter
  should be a water level above the tank bottom (not an elevation). Otherwise \code{level}
  should be a junction pressure.

  To remove a control on a particular link, set the \code{lindex} parameter to 0. Values for the
  other parameters in the function will be ignored.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetcontrol(1)
ENsetcontrol(1, ctype=2, lindex=3, setting=1, nindex=0, level=54)		
ENgetcontrol(1)
ENclose() 
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___controls.html}
\code{ENsetcontrol}
}
