% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.r
\name{ENinitQ}
\alias{ENinitQ}
\title{Initialize water quality analysis}
\usage{
ENinitQ(saveFlag)
}
\arguments{
\item{saveFlag}{boolean or integer indicating whether to save quality results to a file}
}
\value{
Returns NULL invisibly on success or throws an error or warning
}
\description{
Initialize water quality analysis
}
\details{
Call ENinitQ before running quality analysis using ENrunQ with ENnextQ or ENstepQ.  
ENopenQ must have been called prior to calling ENinitQ.  
Do not call ENinitQ with ENsolveQ.
}
\examples{
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENsolveH()
ENsetqualtype("EN_CHEM", "Chlorine", "mg/L", "")
ENopenQ()
ENinitQ(0)
ENrunQ()
ENcloseQ()
}
\seealso{
\url{http://wateranalytics.org/EPANET/group___quality_functions.html}
}
