% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.r
\name{ENsetlinkvalue}
\alias{ENsetlinkvalue}
\title{Set a parameter value for a link}
\usage{
ENsetlinkvalue(index, paramcode, value)
}
\arguments{
\item{index}{of the link}

\item{paramcode}{number or name of parameter code, see details}

\item{value}{new value of the parameter.}
}
\value{
Returns NULL invisibly on success or raises a warning or error.
}
\description{
Set a parameter value for a link
}
\details{
Links are indexed starting from 1.
  
  Link parameter codes consist of the following constants:
  \tabular{lrl}{
  \code{EN_DIAMETER}		\tab 	0	\tab Diameter\cr
  \code{EN_LENGTH}		\tab	1	\tab Length\cr
  \code{EN_ROUGHNESS}	\tab	2	\tab Roughness coeff.\cr
  \code{EN_MINORLOSS}	\tab	3	\tab Minor loss coeff.\cr
  \code{EN_INITSTATUS}	\tab	4	\tab Initial link status (0 = closed, 1 = open)\cr
  \code{EN_INITSETTING}	\tab	5	\tab Pipe roughness\cr
							\tab 		\tab Initial pump speed\cr
							\tab 		\tab Initial valve setting\cr
  \code{EN_KBULK}		\tab 	6	\tab Bulk reaction coeff.\cr
  \code{EN_KWALL}		\tab	7	\tab Wall reaction coeff.\cr
  \code{EN_STATUS}		\tab   11	\tab Current pump or valve status (0 = closed, 1 = open)\cr
  \code{EN_SETTING}		\tab   12	\tab Current pump speed of valve setting.
  }

  Values are supplied in units which depend on the units used for flow rate in the EPANET input file 
  (see Units of Measurement). Use \code{EN_INITSTATUS} and \code{EN_INITSETTING} to set the design value 
  for a link's status or setting that exists prior to the start of a simulation. Use \code{EN_STATUS} and
  \code{EN_SETTING} to change these values while a simulation is being run (within the 
  \code{ENrunH} - \code{ENnextH} loop).
  

  If a control valve has its status explicitly set to \code{OPEN} or \code{CLOSED}, then to make it active again 
  during a simulation you must provide a new valve setting value using the \code{EN_SETTING} parameter.
  
  For pipes, either \code{EN_ROUGHNESS} or \code{EN_INITSETTING} can be used to change roughness.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen(inp, "Net1.rpt")
ENgetlinkvalue(8, "EN_LENGTH")
ENsetlinkvalue(8, "EN_LENGTH", 3333)
ENgetlinkvalue(8, "EN_DIAMETER")
ENclose()
}
