% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.r
\name{ENgetpatternvalue}
\alias{ENgetpatternvalue}
\title{Retrieve the multiplier factor for a specific time period}
\usage{
ENgetpatternvalue(index, period)
}
\arguments{
\item{index}{An integer specifying the time pattern index.}

\item{period}{An integer or integer vector of the periods within the time pattern.}
}
\value{
A numeric or numeric vector, the multiplier factor for the specific time pattern and period.
}
\description{
\code{ENgetpatternvalue} retrieves the multiplier factor for specific time periods in a pattern.
}
\note{
Pattern indexes and periods are consecutive integers starting from 1.
}
\examples{
# path to Net1.inp example file included with this package
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp")  
ENopen( inp, "Net1.rpt")
ENgetpatternvalue(1,1)
ENgetpatternvalue(1,2)
ENgetpatternvalue(1,3)
ENclose()
}
\seealso{
\code{ENgetpatternindex}, \code{ENgetpatternlen}, \code{ENsetpatternvalue}
\url{http://wateranalytics.org/EPANET/group___patterns.html}
}
