% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{envvar_get_file}
\alias{envvar_get_file}
\alias{envvar_get_dir}
\title{Environment variables for files and directories}
\usage{
envvar_get_file(
  x,
  default = NULL,
  create = TRUE,
  check_readable = FALSE,
  check_writable = FALSE,
  transform = NULL,
  warn_default = TRUE,
  ...
)

envvar_get_dir(
  x,
  default = NULL,
  create = TRUE,
  transform = NULL,
  check_readable = FALSE,
  check_writable = FALSE,
  warn_default = TRUE,
  ...
)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{default}{Optional default value if the environment variable is not set}

\item{create}{Create the file or directory if it does not exist (default:
\code{TRUE})}

\item{check_readable}{Ensure that the file or directory is readable}

\item{check_writable}{Ensure that the file or directory is writable}

\item{transform}{Optional function that applies a transformation to the
variable's value}

\item{warn_default}{Show a warning if the default value is used
(default: \code{TRUE})}

\item{...}{Additional arguments passed to \link[fs:create]{fs::file_create} for
\code{envvar_get_file()} or \link[fs:create]{fs::dir_create} for \code{envvar_get_dir()}}
}
\value{
A string containing the path to a file or directory
}
\description{
\code{envvar_get_file()} gets a file name from an environment
variable

\code{envvar_get_dir()} gets a directory name from an environment
variable
}
\examples{
\donttest{
# Get a file path and make sure it exists
envvar_set("MY_DATA" = "data.parquet")
envvar_get_file("MY_DATA")

# Cleanup
file.remove("data.parquet")
}
\donttest{
envvar_set("MY_DATA_DIR" = "data")
envvar_get_dir("MY_DATA_DIR")

# Cleanup
unlink("data", recursive = TRUE)
}
}
